#!/usr/bin/perl
#
# Alexander Thomas, 2020/09/06.
# Released under a Creative Commons CC0 1.0 Universal License
#   (in other words, public domain).
#   https://creativecommons.org/publicdomain/zero/1.0/

use strict;
use warnings;

use utf8;

sub printUsage
{
	print STDERR
	"Usage: $0 [-d] inputFile outputFile\n".
	"Converts a text file from Unicode to RPL (HP) character set or vice versa.\n".
	"Uses the mapping as proposed on www.drehersoft.com/mapping-hp48-text-to-unicode/\n".
	"\n".
	"Options:\n".
	"  -d: inputFile is RPL, output is UTF-8. Otherwise it's the other way round.\n".
	"  -h: show this help.\n";
}


my $decode;

while(defined($ARGV[0]) && $ARGV[0] =~ /^-/) {
	my $arg = shift;
	my @switches = split(//, $arg);
	shift(@switches);
	foreach my $sw (@switches) {
		if($sw eq 'h') {
			printUsage(); exit(0);
		}
		if($sw eq 'd') {
			$decode = 1;
		}
		else {
			print STDERR "WARNING: ignoring unknown switch '${sw}'\n";
		}
	}
}

if($#ARGV < 1) {
	print STDERR "ERROR: missing arguments\n";
	printUsage();
	exit(2);
}

my ($input, $output) = @ARGV;

my ($inFile, $outFile);
if($decode) {
	open($inFile, '<:encoding(latin1)', $input) or die "Cannot read from '${input}': $!\n";
	open($outFile, '>:encoding(UTF-8)', $output) or die "Cannot write to '${output}': $!\n";
	foreach my $line (<$inFile>) {
		$line =~ tr/\x1f\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f/…▒∠ā∇√∫Σ▶π∂≤≥≠α→←↓↑γδεηθλρστωΔΠΩ■∞/;
		print $outFile $line;
	}
	close($inFile);
	close($outFile);
}
else {
	open($inFile, '<:encoding(UTF-8)', $input) or die "Cannot open '${input}': $!\n";
	open($outFile, '>:encoding(latin1)', $output) or die "Cannot write to '${output}': $!\n";
	foreach my $line (<$inFile>) {
		$line =~ tr/…▒∠ā∇√∫Σ▶π∂≤≥≠α→←↓↑γδεηθλρστωΔΠΩ■∞/\x1f\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f/;
		print $outFile $line;
	}
	close($inFile);
	close($outFile);
}
